	function PLOT_DELTA_TG_Z(wT, Taug, axis_Tg_min, axis_Tg_max)
 
	% 	Plots the deviation in the group delay for a digital filter
	%
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2005-05-08
	% 	Modified by: 	LW 2010-11-25
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		
	% 	Known bugs:	 
	% 	Report bugs to:	Wanhammar@gmail.com
 
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================	
	if nargin < 3
		axis_Tg_max = ceil(max(Taug)*1.2);
	end
	hold on;
	plot(wT, Taug,'linewidth', lw)   	
	axis([0 max(wT) axis_Tg_min axis_Tg_max]); %  This may be changed to get a neater plot
 	
	ylabel('{\it\Delta\it\tau_g}({\ite^j^\omega^T}) [T]','FontName', fn,'FontSize',fs);


	%	ylabel('{\it\tau_g}({\ite^j^\omega^T}) [T]','FontName', fn,'FontSize',fs);
	
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};	
	x = floor(max(wT)*10/pi);
	for n = 9:-1:x
		ax(end) = [];	lab(end) = [];
	end
	x = 0;
	while x < min(wT)
		x = x + ax(1);
		ax(1) = [];
		lab(1) = [];
	end
	if max(wT) <= 0.2*pi
		ax = [0 0.05*pi 0.1*pi 0.15*pi 0.2*pi];
		lab = {'0';'0.05\pi';'0.1\pi';'0.15\pi';'0.2\pi'};
	end
	if max(wT) <= 0.05*pi
		ax = [0 0.0125*pi 0.025*pi 0.0375*pi 0.05*pi];
		lab = {'0';'0.0125\pi';'0.0.25\pi';'0.0375\pi';'0.05\pi'};
	end
	xtick(ax,lab);
	box on;
	grid on;
	
	
